/**
 * 
 */
package com.ejie.ab18a.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;

import com.ejie.ab18a.dao.Ab18aEstadoTramitacionDao;
import com.ejie.ab18a.model.Ab18aEstadoTramitacion;
import com.ejie.x38.dto.JQGridRequestDto;

/**
 * @author XXXX
 * 
 */
@Service(value = "ab18aEstadoTramitacionService")
public class Ab18aEstadoTramitacionServiceImpl implements Ab18aEstadoTramitacionService {

	@Autowired()
	private Ab18aEstadoTramitacionDao ab18aEstadoTramitacionDao;

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.ab18a.service.Ab18aEstadoTramitacionService#find(com.ejie.ab18a
	 * .model.Ab18aEstadoTramitacion)
	 */
	public Ab18aEstadoTramitacion find(Ab18aEstadoTramitacion estadoTramitacion) {
		return this.ab18aEstadoTramitacionDao.find(estadoTramitacion);
	}

	/**
	 * Finds a list of rows in the Ab18a15s00 table.
	 * 
	 * @param ab18a15s00
	 *            Ab18a15s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Ab18a15s00>
	 */
	public List<Ab18aEstadoTramitacion> findAll(Ab18aEstadoTramitacion ab18a15s00, JQGridRequestDto jqGridRequestDto) {
		return (List<Ab18aEstadoTramitacion>) this.ab18aEstadoTramitacionDao.findAll(ab18a15s00, jqGridRequestDto);
	}

	public List<Ab18aEstadoTramitacion> findAllMonitor(Ab18aEstadoTramitacion ab18a15s00, JQGridRequestDto jqGridRequestDto) {
		return (List<Ab18aEstadoTramitacion>) this.ab18aEstadoTramitacionDao.findAllMonitor(ab18a15s00, jqGridRequestDto);
	}

	@Override
	public Ab18aEstadoTramitacion update(Ab18aEstadoTramitacion mantenimiento) {
		return this.ab18aEstadoTramitacionDao.update(mantenimiento);
	}

	@Override
	public Ab18aEstadoTramitacion add(Ab18aEstadoTramitacion mantenimiento) throws DataAccessException, Exception {
		return this.ab18aEstadoTramitacionDao.add(mantenimiento);
	}

	@Override
	public Long findAllCount(Ab18aEstadoTramitacion estadoFiltro) {
		return this.ab18aEstadoTramitacionDao.findAllCount(estadoFiltro);
	}

}
